
const btn1 = document.getElementById("btn1");
const value = document.getElementById("value");

let count = 0;

btn1.addEventListener("click", function() {
  count++;
  value.textContent = count;
});

//Scenario 2

document.addEventListener("DOMContentLoaded", () => {
  const tabButtons = document.querySelectorAll(".tabbtn");
  const tabPanels  = document.querySelectorAll(".tabcontent");

  function activateTab(button) {
    // Deactivate all
    tabButtons.forEach(b => {
      b.classList.remove("active");
      b.setAttribute("aria-selected", "false");
      b.setAttribute("tabindex", "-1");
    });
    tabPanels.forEach(p => {
      p.hidden = true;            // a11y-friendly hide
      p.classList.remove("active");
    });

    // Activate selected
    const targetId = button.getAttribute("data-target");
    const panel = document.getElementById(targetId);
    button.classList.add("active");
    button.setAttribute("aria-selected", "true");
    button.removeAttribute("tabindex");
    if (panel) {
      panel.hidden = false;
      panel.classList.add("active");
      panel.focus?.();
    }
  }

  // Click to switch
  tabButtons.forEach(btn => {
    btn.addEventListener("click", () => activateTab(btn));
    // Keyboard support: left/right arrows to move
    btn.addEventListener("keydown", (e) => {
      const currentIndex = [...tabButtons].indexOf(btn);
      if (e.key === "ArrowRight") {
        e.preventDefault();
        const next = tabButtons[(currentIndex + 1) % tabButtons.length];
        next.focus();
        activateTab(next);
      } else if (e.key === "ArrowLeft") {
        e.preventDefault();
        const prev = tabButtons[(currentIndex - 1 + tabButtons.length) % tabButtons.length];
        prev.focus();
        activateTab(prev);
      }
    });
  });

  // Ensure first tab is active on load
  const first = document.querySelector(".tabbtn");
  if (first) activateTab(first);
});



//Scenario 3

document.addEventListener("DOMContentLoaded", () => {
  const form = document.getElementById("jobForm");

  // Helper shortcuts
  const $ = (id) => document.getElementById(id);
  const showErr = (id, msg) => { $(id).textContent = msg || ""; };
  const clearAllErrors = () => {
    document.querySelectorAll(".error").forEach(e => e.textContent = "");
  };

  form.addEventListener("submit", (e) => {
    e.preventDefault(); // stop normal form submit
    clearAllErrors();
    let isValid = true;


    const firstName = $("firstName").value.trim();
    const email = $("email").value.trim();
    const phone = $("phone").value.trim();
    const gender = document.querySelector('input[name="gender"]:checked');
    const address = $("address").value.trim();
    const skills = document.querySelectorAll('input[name="skills"]:checked');
    const experience = $("experience").value;
    const resume = $("resume").files[0];

    
    if (!firstName) {
      showErr("err-firstName", "First name is required.");
      isValid = false;
    }

  
    const emailOk = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
    if (!email) {
      showErr("err-email", "Email is required.");
      isValid = false;
    } else if (!emailOk) {
      showErr("err-email", "Enter a valid email address.");
      isValid = false;
    }


    const phoneOk = /[\d\-\+\(\)\s]{7,}/.test(phone);
    if (!phone) {
      showErr("err-phone", "Phone number is required.");
      isValid = false;
    } else if (!phoneOk) {
      showErr("err-phone", "Enter a valid phone number.");
      isValid = false;
    }


    if (!gender) {
      showErr("err-gender", "Please select a gender option.");
      isValid = false;
    }

 
    if (!address) {
      showErr("err-address", "Address is required.");
      isValid = false;
    }


    if (skills.length === 0) {
      showErr("err-skills", "Select at least one skill.");
      isValid = false;
    }


    if (!experience) {
      showErr("err-experience", "Please choose an experience level.");
      isValid = false;
    }

    
    if (!resume) {
      showErr("err-resume", "Please upload your resume.");
      isValid = false;
    }

    
    if (!isValid) return;

    alert("✅ Form submitted successfully!");
    form.reset();
  });
});
